#!/usr/bin/apt-get script
-- This script will collect all unallowed duplicated pkgs and remove the
-- eldest, keeping the newest. It must be plugged in the slot
-- Scripts::AptGet::Command
--
-- Author: Vladimir D. Seleznev <vseleznv@altlinux.org>
-- Copyright (c) 2019 Vladimir D. Seleznev <vseleznv@altlinux.org>
-- Copyright (c) 2019 ALT Linux Team
-- Copyright (c) 2019 BaseALT Ltd

if script_slot == "Scripts::AptGet::Help::Command" then
    print(_("   dedup - Remove unallowed duplicated pkgs"))
    return
end

if command_args and command_args[1] ~= "dedup" then return end
command_consume = 1

confset("Apt::Get::Fix-Broken", "true")
confset("RPM::Allow-Duplicated-Warning", "false")
allowed_dups = confgetlist("RPM::Allow-Duplicated")

function isAllowed(pkg)
    for i, pattern in pairs(allowed_dups) do
	-- ugly hack: lua is bad at pattern matching
	if os.execute("echo '"..pkg.."' |egrep -q '"..pattern.."'") then
	    return 1
	end
    end
    return nil
end

dups = {}

function processDuplicate(pkg)
    real_name = string.gsub(name, "#.*$", '')
    if not isAllowed(real_name) then
	if dups[real_name] then
	    dups[real_name] = ver
	    -- compare versions of duplicated pkgs, remove the eldest
	    if verstrcmp(verstr(dups[real_name]), verstr(ver)) > 0 then
		markremove(pkg)
	    else
		markremove(verpkg(dups[real_name]))
		dups[real_name] = ver
	    end
	else
	    print(name.." is allowed duplicate")
	end
    end
end

for i, pkg in pairs(pkglist()) do
    name = pkgname(pkg)
    ver = pkgvercur(pkg)

    -- duplicated packages, and they alone, contain '#'
    -- installed packages, and they alone, have ver
    -- check is package non-virtual, installed and duplicated
    if not pkgisvirtual(pkg) and string.find(name, '#') and ver then
	processDuplicate(pkg)
    end
end

